package Plugins::Qobuz::Plugin;

use strict;
use base qw(Slim::Plugin::OPMLBased);

use Slim::Formats::RemoteMetadata;
use Slim::Utils::Log;
use Slim::Utils::Strings qw(string cstring);
#use Slim::Utils::Strings;
use Slim::Utils::Cache;

use Plugins::Qobuz::API;
use Plugins::Qobuz::Settings;

# bump the second parameter if you decide to change the schema of cached data
my $cache = Slim::Utils::Cache->new('qobuz', 1);

my $log = Slim::Utils::Log->addLogCategory( {
	category     => 'plugin.qobuz',
	defaultLevel => 'ERROR',
	description  => 'PLUGIN_QOBUZ',
} );

use constant PLUGIN_TAG       => 'qobuz';
use constant STREAM_URL_REGEX => qr/qobuz\.com/i;

sub initPlugin {
	my $class = shift;
	Plugins::Qobuz::Settings->new;
	
	$log->error("init");
	
	$class->SUPER::initPlugin(
		feed   => \&handleFeed,
		tag    => PLUGIN_TAG,
		menu   => 'radios',
		is_app => 1,
		weight => 1,
	);

	Slim::Formats::RemoteMetadata->registerProvider(
		match => STREAM_URL_REGEX,
		func  => \&provider,
	);	
}

sub provider {
	my ( $client, $url ) = @_;
	return $cache->get($url);
}
  
sub getDisplayName { 'PLUGIN_QOBUZ' }

# don't add this plugin to the Extras menu
sub playerMenu {}


sub handleFeed {
	my ($client, $cb, $args) = @_;
	
	my $params = $args->{params};
	
	$cb->({
		items => [
			{
				name  => cstring($client, 'PLUGIN_QOBUZ_SEARCH'),
				type => 'search',
				url  => \&QobuzSearch
			}
		],
	});
}


sub QobuzSearch {
	my ($client, $cb, $params, $args) = @_;
	
	$params->{search} ||= $args->{q};
	
	my $search = $params->{search};
		
	my $searchResult = Plugins::Qobuz::API->search($search);
		
	my $type = 'playlist';
	my $albums = [];
		
	for my $album ( @{$searchResult->{albums}->{items}} ) {
		push @$albums, {
			name  => $album->{artist}{name} . " - " . $album->{title},
			url   => \&QobuzGetTracks,
			image => $album->{image}{large},
			year => '2005',
			large_art_url => $album->{image}{large},
			passthrough => [{ 
				album_id  => $album->{id},
			}],
			type  => $type,
		};
	}
	
	$cb->( { 
		items => $albums
	} );
}


sub QobuzGetTracks {
	my ($client, $cb, $params, $args) = @_;
	my $albumId = $args->{album_id};
	
	$log->debug($albumId);
	
	my $album = Plugins::Qobuz::API->getAlbums($albumId);
	
	if (!$album) {
		$log->error("Get album ($albumId) failed");
		return;
	}	
	
	my $artistName = $album->{artist}{name};
	my $albumName = $album->{title};
	my $imageURL = $album->{image}{large};
	
	$log->debug($albumName);
	
	my $tracks = [];

	foreach my $track (@{$album->{tracks}->{items}}) {
		my $trackinfo = [];
		my $trackId = $track->{id};
		
		$log->debug(" track id $trackId");

		my $url = Plugins::Qobuz::API->getFileUrl($trackId);

		$log->debug($url);
		
		push @$tracks, {
#			type  => 'link',
			name  => $track->{title},
			name2 => $artistName . " - " . $albumName,
			play  => $url,
			#$track->{streaming_url},
			image => $imageURL,
			cover => $imageURL,
			icon => $imageURL,
			artwork_track_id => $imageURL,
			items => $trackinfo,
			on_select   => 'play',
			playall     => 1,
			passthrough => [{
				track_id => $track->{id}
			}]
		};
		
		
		$cache->set($url, {
			artist => $artistName,
			album => $albumName,
			title => $track->{title},
			cover => $imageURL,
		});
		
		main::idle();
	}
	

	$cb->({
		items => $tracks,
	}, @_ );
}

1;