package Plugins::Qobuz::API;

use strict;
use base qw(Slim::Plugin::OPMLBased);
use JSON::XS::VersionOneAndTwo;
use LWP::UserAgent;
use URI::Escape qw(uri_escape_utf8);
use Digest::MD5 qw(md5_hex);

use constant BASE_URL => 'http://player.qobuz.com/api.json/0.2/';

use Slim::Utils::Cache;
use Slim::Utils::Log;
use Slim::Utils::Prefs;

# bump the second parameter if you decide to change the schema of cached data
my $cache = Slim::Utils::Cache->new('qobuz', 1);
my $prefs = preferences('plugin.qobuz');
my $log = logger('plugin.qobuz');

my $ua = LWP::UserAgent->new(timeout => 15);

sub getToken {
	my $result = _call('/user/login', {
		username => $prefs->get('username'),
		password => $prefs->get('password_md5_hash'),
	});
	
	if ($result) {
		return $result->{user_auth_token};
	}
}

sub search {
	my ($class, $search) = @_;
	
	main::DEBUGLOG && $log->debug('Search : ' . $search);
	
	return _call('search/getResults', {
		type  => 'albums',
		query => $search, 
	});
}

sub getAlbums {
	my ($class, $albumId) = @_;
	
	return _call('album/get', {
		album_id => $albumId,
	});
}

sub getFileUrl {
	my ($class, $trackId) = @_;
	
	if (my $cached = $cache->get("trackUrl_$trackId")) {
		return $cached;
	}
	
	my $track = _call('track/getFileUrl', {
		track_id => $trackId,
		format_id => $prefs->get('preferredFormat'),
		user_auth_token => getToken,
		_ttl  => 30,
		_sign => 1,
	});
	
	if ($track->{url}) {
		# cache urls for a short time only
		$cache->set("trackUrl_$trackId", $track->{url}, 30);
		return $track->{url};
	}
}

sub _call {
	my ($url, $params) = @_;
	
	$params ||= {};
	
	my @query;
	while (my ($k, $v) = each %$params) {
		next if $k =~ /^_/;		# ignore keys starting with an underscore
		push @query, $k . '=' . uri_escape_utf8($v);
	}
	
	push @query, 'app_id=942852567';
	
	# signed requests - see
	# https://github.com/Qobuz/api-documentation#signed-requests-authentification-
	if ($params->{_sign}) {
		my $signature = $url;
		$signature =~ s/\///;
		
		$signature .= join('', sort map {
			my $v = $_;
			$v =~ s/=//;
			$v;
		} grep {
			$_ !~ /(?:app_id|user_auth_token)/
		} @query);
		
		my $ts = time;
		$signature = md5_hex($signature . $ts . '761730d3f95e4af09ac63b9a37ccc96a');
		
		push @query, "request_ts=$ts", "request_sig=$signature";
		
		$params->{_nocache} = 1; 
	}
	
	$url = BASE_URL . $url . '?' . join('&', @query);
	
	main::DEBUGLOG && $log->debug($url);
	
	if (!$params->{_nocache} && (my $cached = $cache->get($url))) {
		main::DEBUGLOG && $log->debug("getting cached value");
		return $cached;
	}
	
	my $response = $ua->get($url);
	
#	main::DEBUGLOG && warn Data::Dump::dump($response);

	if ($response->is_error) {
		my $code = $response->code;
		my $message = $response->message;
		$log->error("request failed: $code  $message");
		$params->{_nocache} = 1;
	}

	my $result = eval { from_json( $response->content ) };
	main::DEBUGLOG && warn Data::Dump::dump($result);

	if (!$params->{_nocache}) {
		$cache->set($url, $result, $params->{_ttl});
	}

	return $result;
}

1;