package Plugins::Qobuz::Plugin;

use strict;
use base qw(Slim::Plugin::OPMLBased);
use JSON::XS::VersionOneAndTwo;
use Tie::Cache::LRU;
use LWP::UserAgent;
use URI::Escape;
use Digest::MD5 qw(md5_hex);


#use Slim::Formats::RemoteMetadata;
use Slim::Utils::Log;
use Slim::Utils::Strings qw(string cstring);

use Plugins::Qobuz::Settings;
use Slim::Utils::Prefs;

my $prefs = preferences('plugin.qobuz');


my $log = Slim::Utils::Log->addLogCategory( {
	category     => 'plugin.qobuz',
	defaultLevel => 'ERROR',
	description  => 'PLUGIN_QOBUZ',
} );

use constant PLUGIN_TAG       => 'qobuz';
#use constant STREAM_URL_REGEX => qr/(?:qobuz)\.com/i;

my $token;
my $username;
my $password_md5_hash;
my $preferredFormat;


sub initPlugin {
	my $class = shift;
	Plugins::Qobuz::Settings->new;
	
	$class->SUPER::initPlugin(
		feed   => \&handleFeed,
		tag    => PLUGIN_TAG,
		menu   => 'radios',
		is_app => 1,
		weight => 1,
	);

	$username = $prefs->get('username');
	$password_md5_hash = $prefs->get('password_md5_hash');
	$preferredFormat = $prefs->get('preferredFormat');

	
	#Slim::Formats::RemoteMetadata->registerProvider(
	#	match => STREAM_URL_REGEX,
	#	func  => \&provider,
	#);	
}



#sub provider {
#  my ( $client, $url ) = @_;
#
#  $log->error($url);
#  
#  return {
#	  artist  => 'Artist Name',
#	  album   => 'Album Name',
#	  title   => 'Track Title',
#	  cover   => 'http://static.qobuz.com/images/jaquettes/0685/0685738343966_600.jpg',
#	  bitrate => 128,
#	  type    => 'Internet Radio',
#  }
#}
  
  
sub getDisplayName { 'PLUGIN_QOBUZ' }

# don't add this plugin to the Extras menu
sub playerMenu {}


sub handleFeed {
	my ($client, $cb, $args) = @_;
	
	my $params = $args->{params};
	
	$cb->({
		items => [
			{
				name  => cstring($client, 'PLUGIN_QOBUZ_SEARCH'),
				type => 'search',
				url  => \&QobuzSearch
			}
		],
	});
}

sub QobuzToken {
	my $h = LWP::UserAgent->new;
	my $response = $h->get("http://player.qobuz.com/api.json/0.2/user/login?app_id=942852567&username=" . $username . "&password=" . $password_md5_hash);
	
	if ($response->is_error) {
		my $code = $response->code;
		my $message = $response->message;
		$log->error("Token ($username:$password_md5_hash) : $code  $message");
	} else {
		my $searchResult  = eval { from_json( $response->content ) };
		$token = $searchResult->{user_auth_token};
		$log->debug("Token : " . $token);
	}
}


sub QobuzSearch {
	my ($client, $cb, $params, $args) = @_;
	
	$params->{search} ||= $args->{q};
	
	my $search = $params->{search};
	
	my $h = LWP::UserAgent->new;

	$log->debug('Search : ' . $search);
	
	my $response = $h->get("http://player.qobuz.com/api.json/0.2/search/getResults?app_id=942852567&type=albums&query=" . uri_escape($params->{search}));

	if ($response->is_error) {
		my $code = $response->code;
		my $message = $response->message;
		$log->error("Search ($search) : $code  $message");
		return
	}
	
	my $searchResult  = eval { from_json( $response->content ) };
		
	my $type = 'playlist';
	my $albums = [];
		
	for my $album ( @{$searchResult->{albums}->{items}} ) {
		push @$albums, {
			name  => $album->{artist}{name} . " - " . $album->{title},
			url   => \&QobuzGetTracks,
			image => $album->{image}{large},
			year => '2005',
			large_art_url => $album->{image}{large},
			passthrough => [{ 
				album_id  => $album->{id},
			}],
			type  => $type,
		};
	}
	
	$cb->( { 
		items => $albums
	} );
}


sub QobuzGetTracks {
	my ($client, $cb, $params, $args) = @_;
	my $albumId = $args->{album_id};
	
	$log->debug($albumId);
	QobuzToken();
	
	my $h = LWP::UserAgent->new;
	
	my $response = $h->get("http://player.qobuz.com/api.json/0.2/album/get?app_id=942852567&album_id=" . uri_escape("$albumId"));
	
	if ($response->is_error) {
		my $code = $response->code;
		my $message = $response->message;
		$log->error("Get album ($albumId) : $code  $message");
		return
	}	
	
	
	my $content = $response->content;
	my $searchResult  = eval { from_json( $content ) };
	
	my $artistName = $searchResult->{artist}{name};
	my $albumName = $searchResult->{title};
	my $imageURL = $searchResult->{image}{large};
	
	$log->debug($albumName);
	
	my $tracks = [];

	foreach my $track (@{$searchResult->{tracks}->{items}}) {
		my $trackinfo = [];
		my $trackId = $track->{id};
		
		$log->debug(" track id $trackId");

		my $ts = time;
		my $sig = md5_hex("trackgetFileUrlformat_id" . $preferredFormat . "track_id" . "$trackId" . "$ts" . "761730d3f95e4af09ac63b9a37ccc96a");

		my $responseTrack = $h->get("http://player.qobuz.com/api.json/0.2/track/getFileUrl?user_auth_token=$token&app_id=942852567&track_id=$trackId&format_id=" . $preferredFormat . "&request_ts=$ts&request_sig=$sig");
		if ($responseTrack->is_error) {
			my $code = $responseTrack->code;
			my $message = $responseTrack->message;
			$log->error("Get track url (track id : $trackId , token : $token) : $code  $message");
			return
		}	
	
		my $contentTrack = $responseTrack->content;

		my $searchResultTrack  = eval { from_json( $contentTrack ) };		
		my $url = $searchResultTrack->{url};

		$log->debug($url);
		
		push @$tracks, {
#			type  => 'link',
			name  => $track->{title},
			name2 => $artistName . " - " . $albumName,
			play  => $url,
			#$track->{streaming_url},
			image => $imageURL,
			cover => $imageURL,
			icon => $imageURL,
			artwork_track_id => $imageURL,
			items => $trackinfo,
			on_select   => 'play',
			playall     => 1,
			passthrough => [{
				track_id => $track->{id}
			}]
		};
	}
	

	$cb->({
		items => $tracks,
	}, @_ );
}

1;